/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.internal.contentassist;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

public class RubyDoubleQuotedStringContentAssistProcessor
extends CommonContentAssistProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private static final Map<String, String> PROPOSALS = new TreeMap<String, String>();

    static {
        PROPOSALS.put("\\", "\\nnn Octal <i>nnn</i>");
        PROPOSALS.put("\\C-", "Control-<i>x</i>");
        PROPOSALS.put("\\M-", "Meta-<i>x</i>");
        PROPOSALS.put("\\M-\\C-", "Meta-control-<i>x</i>");
        PROPOSALS.put("\\a", "Bell/alert (0x07)");
        PROPOSALS.put("\\b", "Backspace (0x08)");
        PROPOSALS.put("\\c", "Control-<i>x</i>");
        PROPOSALS.put("\\e", "Escape (0x1b)");
        PROPOSALS.put("\\f", "Formfeed (0x0c)");
        PROPOSALS.put("\\n", "Newline (0x0a)");
        PROPOSALS.put("\\r", "Return (0x0d)");
        PROPOSALS.put("\\s", "Space (0x20)");
        PROPOSALS.put("\\t", "Tab (0x09)");
        PROPOSALS.put("\\v", "Vertical tab (0x0b)");
        PROPOSALS.put("\\x", "\\xnn: Hex <i>nn</i>");
    }

    public RubyDoubleQuotedStringContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        try {
            String prefix = this.getPrefix(viewer, offset);
            ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
            for (Map.Entry<String, String> entry : PROPOSALS.entrySet()) {
                if (!entry.getKey().startsWith(prefix)) continue;
                result.add(this.createProposal(entry.getKey(), prefix, offset - prefix.length(), entry.getValue()));
            }
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        catch (BadLocationException badLocationException) {
            return NO_PROPOSALS;
        }
    }

    private ICompletionProposal createProposal(String proposal, String prefix, int offset, String description) {
        CompletionProposal p = new CompletionProposal(proposal, offset, prefix.length(), proposal.length(), null, proposal, null, description);
        return p;
    }

    private String getPrefix(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        int length = 0;
        while (--offset >= 0 && this.isPrefixChar(doc.getChar(offset))) {
            ++length;
        }
        return doc.get(offset + 1, length);
    }

    private boolean isPrefixChar(char c) {
        switch (c) {
            case '\\': {
                return true;
            }
        }
        return Character.isLetter(c);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'\\'};
    }
}

